// in:	C = Diffuse
//	N = Normal
//	S = Specular + A(sign(Nz))
void PackData (in vec4 C, in vec3 N, in vec3 S)
{
	N = normalize(N);	// be sure that N normalized! Don't delete this!!!
	gl_FragData[0] = C;
#if defined(RG16F)
	// Stereographic Projection
	gl_FragData[1].xy = N.xy / (N.z + 1.0) * 0.2812623 + 0.5;
	gl_FragData[2] = vec4(S, 0.0);
#else
	N.xy = (N.xy + 1.0) * 0.5;
	vec2 temp = N.xy * 256.0;
	vec2 HxHy = floor(temp) * (1.0/256.0);
	vec2 LxLy = fract(temp);
	gl_FragData[1] = vec4(HxHy.x, LxLy.x, HxHy.y, LxLy.y);
	gl_FragData[2] = vec4(S, (sign(N.z) + 1.0) * 0.25);
#endif
}
